
///\file
///\brief Implementation of the LEMON-CBC lp solver interface.

#include <lemon/lp_cbc.h>

//#include <iostream>


namespace lemon {

	LpCbc::LpCbc() : Parent(){
    messageLevel(1);
	solver=NULL;
  }
   
  LpCbc::~LpCbc() {
	  if (delete_solver) delete solver;
  }
  
  int LpCbc::_addCol() { 
	int i=build.numberColumns();
	build.addCol(0,NULL,NULL, -COIN_DBL_MAX, COIN_DBL_MAX, 0.0);
    return i;
  }

  ///\e


  LpSolverBase &LpCbc::_newLp()
  {
    LpCbc* newlp=new LpCbc;
    return *newlp;
  }
  
  ///\e

  LpSolverBase &LpCbc::_copyLp()
  {
    LpCbc* newlp=new LpCbc(*this);
    return *newlp;
  }

  int LpCbc::_addRow() { 
	int i=build.numberRows();
	build.addRow(0,NULL,NULL,-COIN_DBL_MAX, COIN_DBL_MAX);
    return i;
  }

  
  void LpCbc::_eraseCol(int i) {
	build.deleteColumn(i);
  }
  
  void LpCbc::_eraseRow(int i) {
	build.deleteRow(i);
  }

  void LpCbc::_getColName(int c, std::string & name) const
  {
	name=build.getColName(c);
  }
  
 
  void LpCbc::_setColName(int c, const std::string & name)
  {
	 //build.setIntParam(OsiNameDiscipline,1);
	char *ch, *n=const_cast<char*>(name.c_str());
	while( (ch = strchr(n, ' ')) ) *ch = '_';
	while( (ch = strchr(n, '-')) ) *ch = '_';
	build.setColName(c, name.c_str());
  }

  int LpCbc::_colByName(const std::string& name) const
  {
	  /// \todo use maps
	/* std::vector<std::string> *names =build.getColNames();
	 int id=0;
	 for (std::vector<std::string>::iterator it=names->begin(); it!=names->end;++it){
		 if (name==*it)
			 return id;
		id++;
	 }*/
	 return -1; 
  }

    int LpCbc::_addRow(ConstRowIterator b, ConstRowIterator e, Value lower, Value upper) {
	int i=build.numberRows();
	int numberElements=0;
    for(ConstRowIterator it=b; it!=e; ++it) numberElements++;
	int *columns=new int[numberElements];
	double *element=new double[numberElements];
	int j=0;
    for(ConstRowIterator it=b; it!=e; ++it) {
      columns[j]=it->first;
      element[j]=it->second;
	  j++;
    }
    build.addRow(numberElements,columns,element,lower, upper);
	delete [] columns;
	delete [] element;
	return i;
}
  
  void LpCbc::_setRowCoeffs(int i, ConstRowIterator b, ConstRowIterator e) 
  {
	for (int j = 0; j < build.numberColumns(); ++j) {
      build.setElement(i, j, 0.0);
    }
    for(ConstRowIterator it = b; it != e; ++it) {
      build.setElement(i, it->first, it->second);
    }
  }

  void LpCbc::_getRowCoeffs(int ix, RowIterator b) const
  {
	  ///\todo
	  /*
	const soplex::SVector& vec = soplex->rowVector(i);
    for (int k = 0; k < vec.size(); ++k) {
      *b = std::make_pair(vec.index(k), vec.value(k));
      ++b;
    }*/
  }
  
  void LpCbc::_setColCoeffs(int j, ConstColIterator b, ConstColIterator e) {
    for (int i = 0; i < build.numberRows(); ++i) {
      build.setElement(i, j, 0.0);
    }
    for(ConstColIterator it = b; it != e; ++it) {
      build.setElement(it->first, j, it->second);
    }
  }

  void LpCbc::_getColCoeffs(int ix, ColIterator b) const
  {
	  ///\todo
 /*
     const soplex::SVector& vec = soplex->colVector(i);
    for (int k = 0; k < vec.size(); ++k) {
      *b = std::make_pair(vec.index(k), vec.value(k));
      ++b;
    }*/
  }

  void LpCbc::_setCoeff(int ix, int jx, Value value) 
  {
	build.setElement(ix, jx, value);
  }

  LpCbc::Value LpCbc::_getCoeff(int ix, int jx) const
  {
///\todo
	//build.getCoefficient()

	   // get row copy
  /*CoinPackedMatrix rowCopy = *model.matrix();
  rowCopy.reverseOrdering();
  const int * column = rowCopy.getIndices();
  const int * rowLength = rowCopy.getVectorLengths();
  const CoinBigIndex * rowStart = rowCopy.getVectorStarts();
  
  x[numberColumns]='\0';
  for (iRow=0;iRow<numberRows;iRow++) {
    memset(x,' ',numberColumns);
    for (int k=rowStart[iRow];k<rowStart[iRow]+rowLength[iRow];k++) {
      int iColumn = column[k];
      x[iColumn]='x';
    }
    printf("%s\n",x);
  }*/
    return 0;

  }

  void LpCbc::_setColLowerBound(int i, Value lo)
  {
	build.setColLower(i, lo);
  }

  LpCbc::Value LpCbc::_getColLowerBound(int i) const
  {
	return build.getColumnLower(i);
  }
  
  void LpCbc::_setColUpperBound(int i, Value up)
  {
	build.setColUpper(i, up);
  }

  LpCbc::Value LpCbc::_getColUpperBound(int i) const
  {
    return build.getColumnUpper(i);
  }
  
  void LpCbc::_setRowBounds(int i, Value lb, Value ub)
  {
    build.setRowBounds(i,lb, ub);
  }

  void LpCbc::_getRowBounds(int i, Value &lb, Value &ub) const
  {
	ub=build.getColumnUpper(i);
	lb=build.getColumnLower(i);
  }
  
  void LpCbc::_setObjCoeff(int i, Value obj_coef)
  {
	build.setColumnObjective(i, obj_coef );
  }

  LpCbc::Value LpCbc::_getObjCoeff(int i) const {
    return build.getColumnObjective(i);
  }

  void LpCbc::_clearObj()
  {
    for (int i=0;i<build.numberColumns();++i){
      build.setColumnObjective(i, 0.0);
    }
  }

  LpCbc::SolveExitStatus LpCbc::_solve()
  {
	#ifdef COIN_HAS_CLP
	  solver=new OsiClpSolverInterface();
	#elif COIN_HAS_OSL
	  solver=new OsiOslSolverInterface();
	#endif
	solver->loadFromCoinModel(build);
	solver->initialSolve();
	if (solver->isAbandoned()||
		solver->isIterationLimitReached())
		return UNSOLVED;
	return SOLVED;
  }

  LpCbc::Value LpCbc::_getPrimal(int i) const
  {
	if (solver)
		return solver->getColSolution()[i];
	else 
		return -1;
  }

  LpCbc::Value LpCbc::_getDual(int i) const
  {
	if (solver)
		return solver->getRowActivity()[i]; ///???? or getRowPrice() 
	else 
		return -1;
  }
  
  LpCbc::Value LpCbc::_getPrimalValue() const
  {
	if (solver)
		return solver->getObjValue();
	else 
		return -1;
  }
  bool LpCbc::_isBasicCol(int i) const
  {
	  ///\todo
    return false;//(LEMON_glp(get_col_stat)(lp, i)==LEMON_GLP(BS));
  }

  LpCbc::SolutionStatus LpCbc::_getPrimalStatus() const
  {
	if (!solver)
		return UNDEFINED;
	if (solver->isProvenOptimal())
		 return OPTIMAL;
	if (solver->isProvenPrimalInfeasible() || 
		solver->isProvenDualInfeasible())
         return INFEASIBLE;
//	if (solver->isIterationLimitReached() ||
//		solver->isPrimalObjectiveLimitReached()||
//		solver->isDualObjectiveLimitReached()||
//		solver->isAbandoned())
     return UNDEFINED;
  }

  LpCbc::SolutionStatus LpCbc::_getDualStatus() const
  {
	if (!solver)
		return UNDEFINED;
	if (solver->isProvenOptimal())
		 return OPTIMAL;
	if (solver->isProvenDualInfeasible())
         return INFEASIBLE;
//	if (solver->isIterationLimitReached() ||
//		solver->isDualObjectiveLimitReached()||
//		solver->isAbandoned())
     return UNDEFINED;
  }

  LpCbc::ProblemTypes LpCbc::_getProblemType() const
  {
    /*if (solver->isProvenOptimal())
	return PRIMAL_DUAL_FEASIBLE;
    if ( && model.isDualObjectiveLimitReached())
	return PRIMAL_FEASIBLE_DUAL_INFEASIBLE;
    if ()
	return PRIMAL_INFEASIBLE_DUAL_FEASIBLE;
    if ()
	return PRIMAL_DUAL_INFEASIBLE;*/
    //In all other cases*/
    return UNKNOWN;
  }

  void LpCbc::_setMax()
  {
	build.setOptimizationDirection(-1);
  }

  void LpCbc::_setMin()
  {
    build.setOptimizationDirection(1);
  }

  bool LpCbc::_isMax() const
  {
    return (build.optimizationDirection()==-1);
  }

  void LpCbc::messageLevel(int m)
  {
  /** Amount of print out:
      0 - none
      1 - just final
      2 - just factorizations
      3 - as 2 plus a bit more
      4 - verbose
      above that 8,16,32 etc just for selective debug
  */
	  loglevel=(m<3)?m:4;
  }

  void LpCbc::presolver(bool b)
  {
	///\todo
    //LEMON_lpx(set_int_parm)(lp, LEMON_LPX(K_PRESOL), b);
  }

 
}; //END OF NAMESPACE LEMON
