#ifndef LEMON_LP_CBC_H
#define LEMON_LP_CBC_H

///\file
///\brief Header of the LEMON-CBC lp solver interface.
///\ingroup lp_group

#include <lemon/lp_base.h>

#if defined(_MSC_VER)
// Turn off compiler warning about long names
#  pragma warning(disable:4786)
#endif

#include <cassert>
#include <iomanip>

#include "CbcConfig.h"

#include "OsiSolverInterface.hpp"
#ifdef COIN_HAS_CLP
#include "OsiClpSolverInterface.hpp"
#endif
#ifdef COIN_HAS_OSL
#include "OsiOslSolverInterface.hpp"
#endif
// Methods of building
//#include "CoinBuild.hpp"
#include "CoinModel.hpp"

namespace lemon {


  /// \brief Interface for the CBC LP solver
  /// 
  /// This class implements an interface for the CBC LP solver.
  ///\ingroup lp_group
  class LpCbc : virtual public LpSolverBase {
  protected:

//#ifdef COIN_HAS_CLP
//  OsiClpSolverInterface* solver;
//#elif COIN_HAS_OSL
//  OsiOslSolverInterface* solver;
//#endif
	OsiSolverInterface* solver;
	
	bool delete_solver;
	
	CoinModel build;

	int loglevel;

  public:
    
    typedef LpSolverBase Parent;
    
    LpCbc();
    //LpCbc(const LpCbc &);
    ~LpCbc();
    
  protected:
    virtual LpSolverBase &_newLp();
    virtual LpSolverBase &_copyLp();

    virtual int _addCol();
    virtual int _addRow();
	virtual int _addRow(ConstRowIterator b, ConstRowIterator e, Value lower, Value upper);

    virtual void _eraseCol(int i);
    virtual void _eraseRow(int i);
    virtual void _getColName(int col, std::string & name) const;
    virtual void _setColName(int col, const std::string & name);
    virtual int _colByName(const std::string& name) const;
    virtual void _setRowCoeffs(int i, ConstRowIterator b, ConstRowIterator e);
    virtual void _getRowCoeffs(int i, RowIterator b) const;
    virtual void _setColCoeffs(int i, ConstColIterator b, ConstColIterator e);
    virtual void _getColCoeffs(int i, ColIterator b) const;
    virtual void _setCoeff(int row, int col, Value value);
    virtual Value _getCoeff(int row, int col) const;

    virtual void _setColLowerBound(int i, Value value);
    virtual Value _getColLowerBound(int i) const;
    virtual void _setColUpperBound(int i, Value value);
    virtual Value _getColUpperBound(int i) const;

    virtual void _setRowBounds(int i, Value lower, Value upper);
    virtual void _getRowBounds(int i, Value &lb, Value &ub) const;
    virtual void _setObjCoeff(int i, Value obj_coef);
    virtual Value _getObjCoeff(int i) const;
    virtual void _clearObj();

    ///\e
    
    ///\todo It should be clarified
    ///
    virtual SolveExitStatus _solve();
    virtual Value _getPrimal(int i) const;
    virtual Value _getDual(int i) const;
    virtual Value _getPrimalValue() const;
    virtual bool _isBasicCol(int i) const;
    ///\e
    
    ///\todo It should be clarified
    ///
    virtual SolutionStatus _getPrimalStatus() const;
    virtual SolutionStatus _getDualStatus() const;
    virtual ProblemTypes _getProblemType() const;

    virtual void _setMax();
    virtual void _setMin();

    virtual bool _isMax() const;

  public:
    ///Set the verbosity of the messages

    ///Set the verbosity of the messages
    ///
    ///\param m is the level of the messages output by the solver routines.
    ///The possible values are:
    ///- 0 --- no output (default value)
    ///- 1 --- error messages only
    ///- 2 --- normal output
    ///- 3 --- full output (includes informational messages)
    void messageLevel(int m);
    ///Turns on or off the presolver

    ///Turns on (\c b is \c true) or off (\c b is \c false) the presolver
    ///
    ///The presolver is off by default.
    void presolver(bool b);

    //LPX *lpx() {return lp;}
  };
} //END OF NAMESPACE LEMON

#endif //LEMON_LP_CBC_H

