#define REMOVE_BEFORE_RELEASE

#include "test_log.h"
#include <lemon/planar_graph.h>
#include <iostream>

using namespace lemon;
using namespace std;

void planar_graph_test() {
    cout << "Planar graph test" << endl;
    PlanarGraph g;
    PlanarGraph::Node n0 = g.addNode();
    PlanarGraph::Node n1 = g.addNode();
    PlanarGraph::Node n2 = g.addNode();
    PlanarGraph::Node n3 = g.addNode();
    PlanarGraph::Edge a0 = g.addEdge(n0,n1,INVALID,INVALID);
    PlanarGraph::Edge a1 = g.addEdge(n0,n2,a0,INVALID);
    PlanarGraph::Edge a2 = g.addEdge(n0,n3,a1,INVALID);
    PlanarGraph::Edge a3 = g.addEdge(n1,n2,a0,a1);
    PlanarGraph::Edge a4 = g.addEdge(n3,n2,a2,a3);
    PlanarGraph::Edge a5 = g.addEdge(n1,n3,a3,a2);
    cout << g.id(a5) << endl;   //should output "-1" (invalid)
    ccwTest(g,n0);    //should output 1 3 5
    ccwTest(g,n1);    //should output 0 7
    ccwTest(g,n2);    //should output 2 6 8
    ccwTest(g,n3);    //should output 4 9

//    g.erase(a1);
//    a5 = g.addEdge(n1,n3,a3,a2);

    g.print();

    //list arcs for each face
    cout << "Face: arcs (CW)" << endl;
    for (PlanarGraph::FaceIt it(g); it != INVALID; ++it) {
        cout << g.id(it) << ": ";
        for (PlanarGraph::CwPerimeterArcIt it2(g,it); it2 != INVALID; ++it2) {
            cout << g.id(it2) << " ";
        }
        cout << endl;
    }
    cout << endl;

    cout << "Dual test: " << endl;
    PlanarGraph::Dual d(g);
    cout << "Face: arcs (CW)" << endl;
    for (PlanarGraph::Dual::FaceIt it(d); it != INVALID; ++it) {
        cout << d.id(it) << ": ";
        for (PlanarGraph::Dual::CwPerimeterArcIt it2(d,it); it2 != INVALID; ++it2) {
            cout << d.id(it2) << " ";
        }
        cout << endl;
    }
    cout << "Node: arcs (CCW)" << endl;
    for (PlanarGraph::Dual::NodeIt it(d); it != INVALID; ++it) {
        cout << d.id(it) << ": ";
        for (PlanarGraph::Dual::CcwArcIt it2(d,it); it2 != INVALID; ++it2) {
            cout << d.id(it2) << " ";
        }
        cout << endl;
    }
    cout << endl;
}
