#define REMOVE_BEFORE_RELEASE

#include "plane_test0.h"
#include "test_log.h"
#include <lemon/plane_graph.h>
#include <iostream>

using namespace std;
using namespace lemon;

void plane_graph_test() {
    cout << "Plane graph test" << endl;
    PlaneGraph g;
    PlaneGraph::Node n0 = g.addNode(dim2::makePoint(0.0,1.0));
    PlaneGraph::Node n1 = g.addNode(dim2::makePoint(0.0,0.0));
    PlaneGraph::Node n2 = g.addNode(dim2::makePoint(1.0,0.0));
    PlaneGraph::Node n3 = g.addNode(dim2::makePoint(1.0,1.0));
    PlaneGraph::Edge a0 = g.addEdge(n0,n1);
    PlaneGraph::Edge a1 = g.addEdge(n0,n2);
    PlaneGraph::Edge a2 = g.addEdge(n0,n3);
    PlaneGraph::Edge a3 = g.addEdge(n1,n2);
    PlaneGraph::Edge a4 = g.addEdge(n3,n2);
    PlaneGraph::Edge a5 = g.addEdge(n1,n3);
    cout << g.id(a5) << endl;   //should output "-1" (invalid)
    ccwTest2(g,n0);    //should output 1 3 5
    ccwTest2(g,n1);    //should output 0 7
    ccwTest2(g,n2);    //should output 2 6 8
    ccwTest2(g,n3);    //should output 4 9

    //list arcs for each face
    cout << "Face: arcs (CW)" << endl;
    for (PlanarGraph::FaceIt it(g); it != INVALID; ++it) {
        cout << g.id(it) << ": ";
        for (PlaneGraph::CwPerimeterArcIt it2(g,it); it2 != INVALID; ++it2) {
            cout << g.id(it2) << " ";
        }
        cout << endl;
    }
    cout << endl;
}
