#define REMOVE_BEFORE_RELEASE

#include "test_log.h"
#include "split.h"
#include <lemon/planar_graph.h>
#include <iostream>

using namespace lemon;
using namespace std;

void planar_graph_arc_split_test() {
    cout << "Planar graph arc split test" << endl;
    PlanarGraph g;
    PlanarGraph::Node n0 = g.addNode();
    PlanarGraph::Node n1 = g.addNode();
    PlanarGraph::Node n2 = g.addNode();
    PlanarGraph::Node n3 = g.addNode();
    PlanarGraph::Edge a0 = g.addEdge(n0,n1,INVALID,INVALID);
    PlanarGraph::Edge a1 = g.addEdge(n0,n3,a0,INVALID);
    PlanarGraph::Edge a2 = g.addEdge(n0,n2,a0,INVALID);
    PlanarGraph::Edge a3 = g.addEdge(n1,n3,a0,a1);
    PlanarGraph::Edge a4 = g.addEdge(n3,n2,a1,a2);
    printNodesWithArcs(g);
    printFacesWithArcs(g);
    g.split(a1);
    cout << endl << "After splitting:" << endl;
    printNodesWithArcs(g);
    printFacesWithArcs(g);
    cout << endl;
}

