#include <lemon/list_graph.h> // ListDigraph

#include <limits> // numeric_limits
#include <iostream> // cout, endl

class MyClass
{
public:
  typedef size_t Id;
  MyClass( const Id id = 0 )
    : mId( id )
  {
    std::cout << "MyClass::MyClass() called." << std::endl;
  }
  MyClass( const MyClass& rOther )
    : mId( rOther.mId )
  {
    std::cout << "MyClass::MyClass( const MyClass& ) called." << std::endl;
  }
  MyClass& operator=( const MyClass& rOther )
  {
    std::cout << "MyClass& MyClass::operator=( const MyClass& ) called." << std::endl;
    mId = rOther.mId;
    return *this;
  }
  ~MyClass()
  {
    std::cout << "MyClass::~MyClass() called." << std::endl;
  }
  friend bool operator==( const MyClass& rLhs, const MyClass& rRhs );
  friend std::ostream& operator<<( std::ostream& rOs, const MyClass& rThis );
private:
  size_t mId;
}; // class MyClass

inline bool operator==( const MyClass& rLhs, const MyClass& rRhs )
{
  return rLhs.mId == rRhs.mId;
}

inline std::ostream& operator<<( std::ostream& rOs, const MyClass& rThis )
{
  rOs << "{ mId: " << rThis.mId << " }";
  return rOs;
}


int main( int argc, char* argv[] )
{
  std::cout << "Creating the digraph." << std::endl;
  lemon::ListDigraph digraph;
  std::cout << "Adding a node to the digraph." << std::endl;
  digraph.addNode();
  std::cout << "Adding a node to the digraph." << std::endl;
  digraph.addNode();

  std::cout << "Constructing my initial-value." << std::endl;
  const MyClass initial_map_value = MyClass( -1 );
  std::cout << "Creating the map." << std::endl;
  lemon::ListDigraph::NodeMap< MyClass > node_to_value_map( digraph,
                                                            initial_map_value );

  std::cout << "Adding a node to the digraph." << std::endl;
  digraph.addNode();
  std::cout << "Adding a node to the digraph." << std::endl;
  digraph.addNode();

  for( lemon::ListDigraph::NodeIt iter( digraph );
       iter != lemon::INVALID; ++iter )
  {
    const MyClass& expected_map_value = initial_map_value;
    const bool b_matched = node_to_value_map[ iter ] == expected_map_value;
    std::cout << "For Digraph Node ID: " << digraph.id( iter ) << ", "
              << "the expected map value is: " << expected_map_value << ", "
              << ( b_matched ? "and " : "but " )
              << "the observed map value is: " << node_to_value_map[ iter ]
              << "." << std::endl;
  }

  std::cout << "About to destroy all local-scoped variables." << std::endl;
  return 0;
}
