#include "lemon/list_graph.h"
#include "lemon/lgf_reader.h"

#include <iostream>

using namespace lemon;

int main() {
  ListDigraph graph;
  ListDigraph::NodeMap<int> nlabel(graph);
  DigraphReader<ListDigraph>(graph, "lookupTest.lgf")
    .nodeMap("label",nlabel)
    .run();
	
  AllArcLookUp<ListDigraph> lookup(graph);
	
  int numArcs = countArcs(graph);
	
  int arcCnt = 0;
  for(ListDigraph::NodeIt n1(graph); n1 != INVALID; ++n1) {
    int cnt = 0;
    for(ListDigraph::NodeIt n2(graph); n2 != INVALID; ++n2) {
      int cnt2 = 0;
      for(ListDigraph::Arc a = lookup(n1, n2); a != INVALID;
	  a = lookup(n1, n2, a)) {
	++arcCnt;
	++ cnt;
	++ cnt2;
      }
      std::cout << "    " << nlabel[n1] << "->" << nlabel[n2] << ": " << cnt2
		<< std::endl;
    }
    std::cout << "  " << nlabel[n1] << ": " << cnt
	      << std::endl;
  }
	
  std::cout << numArcs << "," << arcCnt << std::endl;
	
  return 0;
}
