#include <iostream>
#include <vector>

#include <lemon/list_graph.h>
#include <lemon/dfs.h>

using std::vector;
using std::cout;
using std::endl;

int main(int,char**) {

    typedef lemon::ListDigraph graph_t;
    typedef graph_t::Node Node;
    typedef graph_t::NodeIt NodeIt;

    // define a simple graph
    graph_t graph;
    Node n0 = graph.addNode();
    Node n1 = graph.addNode();
    Node n2 = graph.addNode();
    Node n3 = graph.addNode();
    graph.addArc(n0, n3);
    graph.addArc(n1, n2);

    // add the same two nodes to DFS but in different order
    vector<Node> list_1({n1,n0});
    vector<Node> list_2({n0,n1});
    for(auto list : {list_1,list_2}) {
        lemon::Dfs<graph_t> search(graph);
        search.init();
        for(Node node : list) {
            cout << "add node " << graph.id(node) << endl;
            search.addSource(node);
        }
        search.start();
        for(NodeIt node(graph); node!=lemon::INVALID; ++node) {
            if(search.reached(node)) {
                cout << "node " << graph.id(node) << ": reached" << endl;
            } else {
                cout << "node " << graph.id(node) << ": NOT reached" << endl;
            }
        }
        cout << endl;
    }
}
