#include <iostream>
#include "lemon_mcf_solve.h"
#include <cstdio>

class Constraint {
    public:
        int s,t,b,c;
        Constraint(int s, int t, int b, int c) : s(s), t(t), b(b), c(c) {}
};

int main( int argc, char *argv[] ) {

    if(argc!=3){
        printf("usage: %s INPUT_FILE SCALE\n", argv[0]);
        return 0;
    }else{
        printf(" INFO: opening %s\n", argv[1]);
    }

    std::vector<Constraint> l1minproblem;
    double scale = atof(argv[2]);
    printf(" INFO: scaling costs by %lf\n", scale);

    FILE *stream = 0;
    stream = fopen(argv[1],"r");
    if ( !stream ) {
        printf(" ERROR: failed to open file %s\n", argv[1]);
        return -1;
    }
    int n_nodes = 0;
    int n_constraints = 0;
    fscanf(stream,"%d %d\n",&n_nodes, &n_constraints);
    for ( int i = 0; i < n_constraints; ++i ) {
        int s, t, b, c;
        fscanf(stream,"%d %d %d %d\n", 
                &s, &t, &b, &c); 
        l1minproblem.push_back(Constraint(s, t, -scale*b, c));
    }
    printf(" INFO: nnodes> %d\n", n_nodes);
    printf(" INFO: nconstraints> %d\n", n_constraints);
    fclose(stream);
    
    printf(" INFO: launching the solvers ...\n");
    solve(n_nodes, l1minproblem.size(),l1minproblem.begin() );

}
