#include <iostream>
#include <lemon/list_graph.h>
#include <lemon/lgf_reader.h>
#include <lemon/matching.h>


using namespace lemon;

typedef ListGraph UGraph;
typedef UGraph::EdgeMap<double> LengthMap;
typedef MaxWeightedPerfectMatching<UGraph,LengthMap> MWPM;

void SolveMatchingFromFile(std::string filename){
	UGraph graph;
	LengthMap length(graph);

	try {
		GraphReader<UGraph> reader(graph, filename);
		reader.edgeMap("weight",length);
		reader.run();
	} catch (FormatError& error) {
		std::cerr << error.what() << std::endl;
	}
	
	MWPM pm(graph, length);
	bool success = pm.run();

	std::cout << filename << ":   ";
	if (success){
		std::cout << "succeeded" << std::endl;
	} else {
		std::cout << "failed" << std::endl;
	}
}

int main() {
	SolveMatchingFromFile("failing_graph_1.lgf");
	SolveMatchingFromFile("failing_graph_2.lgf");
	SolveMatchingFromFile("failing_graph_3.lgf");
	SolveMatchingFromFile("failing_graph_4.lgf");
	SolveMatchingFromFile("working_graph.lgf");
	return 0;
}
